#!/usr/local/bin/perl
# Disallow remote SSH logins

require './virtualmin-support-lib.pl';
&ReadParse();
&error_setup($text{'disable_err'});

&ui_print_unbuffered_header(undef, $text{'disable_title'}, "");

# Remove SSH keys
$kfile = &get_authorized_keys_file();
print &text('disable_keys', "<tt>$kfile</tt>"),"<br>\n";
&lock_file($kfile);
&save_virtualmin_ssh_keys();
&unlock_file($kfile);
print $text{'enable_done'},"<br>\n";

# Remove at job
$atjob = &get_disable_login_job();
if ($atjob) {
	print "<br data-x-br>";
	print $text{'disable_end'},"<br>\n";
	&at::delete_atjob($atjob->{'id'});
	print $text{'enable_done'},"<br>\n";
	}

# Remove Webmin user
@users = &acl::list_users();
($user) = grep { $_->{'name'} eq $login_webmin_user } @users;
if ($user) {
	print "<br data-x-br>";
	print &text('disable_webmin', "<tt>$login_webmin_user</tt>"),"<br>\n";
	&acl::delete_user($login_webmin_user);
	print $text{'enable_done'},"<br>\n";
	}

&webmin_log("disable");
&ui_print_footer("index.cgi?mode=login", $text{'index_return'});

