#!/usr/local/bin/perl
# Allow remote SSH logins

require './virtualmin-support-lib.pl';
use Time::Local;
&ReadParse();
$main::theme_prevent_make_date = 1;
&error_setup($text{'enable_err'});
&foreign_require("sshd", "sshd-lib.pl");

# Validate inputs
if (!$in{'end_def'}) {
	eval { $end = timelocal(59, 59, 23, $in{'day'}, $in{'month'}-1,
			        $in{'year'}-1900) };
	if ($@) {
		&error(&text('enable_eend', $@));
		}
	&foreign_installed("at") || &error($text{'enable_eat'});
	}

# Check if root SSH logins are supported
$conf = &sshd::get_sshd_config();
$permit = &sshd::find_value("PermitRootLogin", $conf);
if (lc($permit) eq "no") {
	&error(&text('enable_eroot', '../sshd/edit_users.cgi'));
	}
$protos = &sshd::find_value("Protocol", $conf);
if ($protos && $protos !~ /2/) {
	&error(&text('enable_eprotos', '../sshd/edit_net.cgi'));
	}
$pub = &sshd::find_value("PubkeyAuthentication", $conf);
if (lc($pub) eq "no") {
	&error(&text('enable_epub', '../sshd/edit_users.cgi'));
	}
$port = &sshd::find_value("Port", $conf);
$port ||= 22;

&ui_print_unbuffered_header(undef, $text{'enable_title'}, "");

# Add the keys
$kfile = &get_authorized_keys_file();
print &text('enable_keys', "<tt>$kfile</tt>"),"<br>\n";
&lock_file($kfile);
&save_virtualmin_ssh_keys(&available_virtualmin_ssh_keys());
&unlock_file($kfile);
print "<pre>",&html_escape(&read_file_contents(
		"$module_root_directory/virtualmin_keys")),"</pre>\n";
print $text{'enable_done'},"<br>\n";

# Setup an at job to remove, if needed
if (!$in{'end_def'}) {
	print "<br data-x-br>";
	print &text('enable_end', &make_date($end)),"<br>\n";
	&cron::create_wrapper($disable_login_cmd, $module_name,
			      "disable-login.pl");
	&at::create_atjob("root", $end, $disable_login_cmd,
			  $module_root_directory);
	print $text{'enable_done'},"<br>\n";
	}

# Create Webmin user, with all modules by no valid password
if ($in{'webmin'}) {
	print "<br data-x-br>";
	print &text('enable_webmin', "<tt>$login_webmin_user</tt>"),"<br>\n";
	@users = &acl::list_users();
	($clash) = grep { $_->{'name'} eq $login_webmin_user } @users;
	($me) = grep { $_->{'name'} eq $base_remote_user } @users;
	if ($clash) {
		print $text{'enable_already'},"<br><br data-x-br>\n";
		}
	else {
		$user = { 'name' => $login_webmin_user,
			  'pass' => '*LK*',
			  'modules' => $me ? $me->{'modules'} : [ '*' ],
			  'lang' => 'en',
			  'real' => 'Remote Developer Access',
			};
		&acl::create_user($user);
		&reload_miniserv();
		print $text{'enable_done'},"<br><br data-x-br>\n";
		}
	}

# Build the email
print &text('enable_email', "<tt>$virtualmin_remote_email</tt>"),"<br>\n";
$host = &get_system_hostname();
$ip = &get_external_ip_address();
$ipinternal = &to_ipaddress($host);
$nowstr = &html_strip(&make_date(time()));
$endstr = $in{'end_def'} ? "Never" : &html_strip(&make_date($end));
$body = "Remote root SSH access to the user's system has been granted.\n\n".
        "Hostname:         $host\n".
        "SSH port:         $port\n".
        "Internal IP:      $ipinternal\n".
        "External IP:      $ip\n".
        "Granted at:       $nowstr\n".
        "Expires at:       $endstr\n";
if ($in{'webmin'}) {
	$body .= "Webmin user:      $login_webmin_user\n";
	}
if ($in{'bug'} =~ /^\S+$/) {
	$body .= "Bug URL:          ".$in{'bug'}."\n";
	}
if ($in{'comments'}) {
	$body .= "Comments:         ";
	$in{'comments'} =~ s/\r//g;
	$in{'comments'} =~ s/\n*$//;
	$body .= $in{'comments'}."\n";
	}

# Send email to Virtualmin developers
$from = &mailboxes::get_from_address();
&mailboxes::send_text_mail(
	"Remote Access Request <$from>",
	$virtualmin_remote_email,
	undef,
	"Remote access to the system on $host:$port",
	$body,
	);
print $text{'enable_sent'},"<br>\n";

&webmin_log("enable");
&ui_print_footer("index.cgi?mode=login", $text{'index_return'});

