#!/usr/local/bin/perl
# Show icons for SSH login and bug filing

require './virtualmin-support-lib.pl';
&ReadParse();
&ui_print_header(undef, &html_escape($in{'moddesc'}) || $module_info{'desc'}, "", undef, 0, 1);
my @tabs = map { [ $_, $text{"${_}_title"}, "index.cgi?mode=$_" ] }
        ( "ticket", "login" );

print &ui_tabs_start(\@tabs, "mode", $in{'mode'} || $tabs[0]->[0], 1);

my $structured_sysinfo = get_structured_sysinfo();
my $markdown_url_param = get_markdown_url_param($structured_sysinfo);

# Submit Ticket tab
print &ui_tabs_start_tab("mode", "ticket");
print &text('ticket_description', &ui_link($virtualmin_community, $text{'ticket_community'}, undef, 'target="_blank"'), &feature_name()),"<p>\n";
print "<center>" . &ui_link("https://forum.virtualmin.com/new-message?groupname=staff&body=$markdown_url_param", $text{'ticket_submit'}, undef, 'target="_blank" data-submit-ticket') . "</center>";

print ui_tabs_end_tab();

# Remote login tab
print &ui_tabs_start_tab("mode", "login");
@keys = &get_virtualmin_ssh_keys();
$atjob = &get_disable_login_job();
if (@keys) {
    # Login is allowed, perhaps up to some date. Offer to turn off now.
    print &ui_form_start("disable_login.cgi");

    if ($atjob) {
        print &text('login_disabledesc2',
                &make_date($atjob->{'date'})),"<p>\n";
        }
    else {
        print &text('login_disabledesc'),"<p>\n";
        }

    print &ui_form_end([ [ undef, $text{'login_disable'} ] ]);
    }
else {
    # Login is not allowed. Offer to setup, expiry by default in 3 days
    print &text('login_enabledescription', $config{'user'} || 'root',
        &feature_short_name(), &feature_short_name()),"<p>\n";
    print &ui_form_start("enable_login.cgi");
    print &ui_table_start(undef, undef, 2);

    # Expiry date
    @tm = localtime(time() + 3*24*60*60);
    print &ui_table_row($text{'login_end'},
        &ui_radio("end_def", 1, [ [ 1, $text{'login_never'}."<br>" ],
                      [ 0, $text{'login_date'} ] ])."\n".
        &ui_date_input($tm[3], $tm[4]+1, $tm[5]+1900,
                   "day", "month", "year")." ".
        &date_chooser_button('day', 'month', 'year'));

    # Create Webmin login?
    print &ui_table_row(" ",
        &ui_checkbox("webmin", 1,
            &text('login_webmin', "<tt>$login_webmin_user</tt>"), 1));

    # Bug number
    print &ui_table_row($text{'login_bug'},
        &ui_textbox("bug", undef, 40, undef, undef, "placeholder=\"$virtualmin_community/t/000000\""));

    # Additional comments
    print &ui_table_row($text{'login_comments'},
        &ui_textarea("comments", undef, 5, 70));


    print &ui_table_end();
    print &ui_form_end([ [ undef, $text{'login_enable'} ] ]);
    }

print &ui_tabs_end_tab();

print ui_tabs_end(1);

&ui_print_footer();

