
require 'virtualmin-support-lib.pl';

sub module_install
{
# Add to Virtualmin's plugin list
if (&foreign_check("virtual-server")) {
	my %vconfig = &foreign_config("virtual-server");
	my @plugins = split(/\s+/, $vconfig{'plugins'});
	if (&indexof($module_name, @plugins) < 0) {
		push(@plugins, $module_name);
		$vconfig{'plugins'} = join(" ", @plugins);
		$vconfig{'last_check'} = time()+1;
		&save_module_config(\%vconfig, "virtual-server");
		}
	}
# Add to Cloudmin's plugin list
if (&foreign_check("server-manager")) {
	my %cconfig = &foreign_config("server-manager");
	my @plugins = split(/\s+/, $cconfig{'plugins'});
	if (&indexof($module_name, @plugins) < 0) {
		push(@plugins, $module_name);
		$cconfig{'plugins'} = join(" ", @plugins);
		&save_module_config(\%cconfig, "server-manager");
		}
	}
}

